# 이상 (Anomaly)

Relation\* 처리 과정에서 일부 속성들의 종속이나 데이터의 중복으로 인해 발생하는 오류를 말한다.  

_\*Relation : 관계형 데이터베이스에서 정보를 구분하여 저장하는 기본 단위로, Table과 같은 의미로 사용된다. 튜플(Tuple)과 속성(Attribute)으로 구성된다._

<br>

## 이상(Anomaly) 현상으로 인한 문제점
- 현실의 실제 값과 DB에 저장된 값이 일치하지 않을 수도 있다.
- 중복된 데이터에 대해 데이터 불일치 현상이 발생할 수도 있다.
- 전체적인 무결성이 저하된다.

<br>

## 이상(Anomaly) 현상 종류

|   학번   |  이름  | 과목ID |   과목명   | 교수명 |
| :------: | :----: | :----: | :--------: | ------ |
| 20220001 | 이규현 |   A1   |  운영체제  | 홍지만 |
| 20220002 | 이도하 |   A2   |  자료구조  | 김익수 |
| 20220003 | 최다인 |   A2   |  자료구조  | 김익수 |
| 20220004 | 함인규 |   B1   | 컴퓨터비전 | 송현주 |

<br>

### 삽입 이상

**자료를 삽입할 때 의도하지 않은 불필요한 자료까지 삽입해야만 테이블에 추가가 가능한 현상**<br/>
새로운 학생을 테이블에 추가할 때, 주목하고자 하는 학생에 대한 정보 뿐만 아니라 불필요하게 과목에 대한 정보까지 추가해야 삽입이 가능하다. 또한 강의를 수강하지 않는 새로운 학생을 삽입할 경우 과목ID와 과목명 속성에 null 값이 들어가야 삽입이 가능하다.  

### 갱신 이상

**중복된 데이터 중 일부만 수정되어 데이터 모순이 일어나는 이상**<br/>
과목ID가 A2인 자료구조를 알고리즘으로 수정할 경우, 2번째 튜플과 3번째 튜플의 과목명을 모두 변경해야 한다. 만약 2번째 튜플에서만 과목명이 알고리즘으로 변경되었다면, 3번째 튜플에서는 같은 과목ID임에도 불구하고 과목명이 달라지게 된다.  

### 삭제 이상

**어떤 정보를 삭제하면, 유용한 다른 정보까지 삭제되어버리는 이상**<br/>
테이블에서 4번째 튜플을 삭제하는 경우, 함인규 학생에 대한 정보만 지워지면 되는데 컴퓨터비전 과목에 대한 정보까지 지워지게 된다.  

<br>

## 이상 현상 방지 방법

[정규화](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Database/%EC%A0%95%EA%B7%9C%ED%99%94.md)를 사용한다.

<br>

## Reference

- https://kosaf04pyh.tistory.com/294
- https://deep-deep-deep.tistory.com/161
- https://developer-talk.tistory.com/256
- https://1000hg.tistory.com/22
- https://dev-coco.tistory.com/63